"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.setRenderLayerRecursively = exports.getOrCreateScreenTransform = exports.setRenderOrderRecursivelyRelativeToParent = exports.setRenderOrderRecursively = exports.findParent = exports.forEachChild = exports.findSoWithComponent = exports.findParentComponent = exports.findOneByType = void 0;
function findOneByType(components, type) {
    if (!components)
        return [];
    for (const c of components) {
        if (c.isOfType(type)) {
            return [c];
        }
    }
    return [];
}
exports.findOneByType = findOneByType;
function findParentComponent(sceneObject, componentType) {
    let so = sceneObject;
    while (so != null) {
        const comp = so.getComponent(componentType);
        if (comp)
            return comp;
        so = so.getParent();
    }
    return null;
}
exports.findParentComponent = findParentComponent;
function findSoWithComponent(so, componentType, soArray) {
    if (!soArray) {
        soArray = [];
    }
    const comp = so.getComponent(componentType);
    if (!isNull(comp)) {
        soArray.push(so);
    }
    for (let i = 0; i < so.getChildrenCount(); i++) {
        findSoWithComponent(so.getChild(i), componentType, soArray);
    }
    return soArray;
}
exports.findSoWithComponent = findSoWithComponent;
function forEachChild(so, fn) {
    if (!isNull(so))
        fn(so);
    so.children.forEach(so => forEachChild(so, fn));
}
exports.forEachChild = forEachChild;
function findParent(so, predicate) {
    let parent = so;
    do {
        parent = parent.getParent();
    } while (parent && !predicate(parent));
    return parent;
}
exports.findParent = findParent;
function setRenderOrderRecursively(so, renderOrder) {
    const visuals = so.getComponents('Visual');
    for (const visual of visuals) {
        visual.setRenderOrder(renderOrder);
    }
    for (let i = 0; i < so.getChildrenCount(); i++) {
        setRenderOrderRecursively(so.getChild(i), renderOrder);
    }
}
exports.setRenderOrderRecursively = setRenderOrderRecursively;
function setRenderOrderRecursivelyRelativeToParent(so, renderOrder) {
    const visuals = so.getComponents('Visual');
    for (const visual of visuals) {
        visual.setRenderOrder(visual.getRenderOrder() + renderOrder);
    }
    for (let i = 0; i < so.getChildrenCount(); i++) {
        setRenderOrderRecursivelyRelativeToParent(so.getChild(i), renderOrder);
    }
}
exports.setRenderOrderRecursivelyRelativeToParent = setRenderOrderRecursivelyRelativeToParent;
function getOrCreateScreenTransform(sceneObject, destructionHelper) {
    let st = sceneObject.getComponent('Component.ScreenTransform');
    if (isNull(st)) {
        st = destructionHelper.createComponent(sceneObject, 'Component.ScreenTransform');
    }
    st.position = new vec3(0, 0, 0);
    return st;
}
exports.getOrCreateScreenTransform = getOrCreateScreenTransform;
function setRenderLayerRecursively(so, layer) {
    so.layer = layer;
    let child;
    for (let i = 0; i < so.getChildrenCount(); i++) {
        child = so.getChild(i);
        setRenderLayerRecursively(child, layer);
    }
}
exports.setRenderLayerRecursively = setRenderLayerRecursively;
//# sourceMappingURL=ComponentUtils.js.map